unit EanAceReg;

interface

uses DsgnIntf;

type
   TAceEanEditor =class(TDefaultEditor)
   public
   	procedure ExecuteVerb(Index: Integer); override;
   	function GetVerb(Index: Integer): string; override;
   	function GetVerbCount: Integer; override;
   end;

procedure Register;

implementation

uses EanKod, EanAce, EanAceDB, Classes;

{$R EanAce.res}

procedure TAceEanEditor.ExecuteVerb(Index: Integer);
var E:TCustomEan;
begin
   if Component is TAceCustomEan then E:=TAceCustomEan(Component).Ean
   else                               E:=nil;

   if E<>nil then
	case Index of
		0 : E.Copyright;
                1 : E.ActiveSetupWindow;
	end;
end;

function TAceEanEditor.GetVerb(Index: Integer): String;
begin
	case Index of
		0 : Result := 'EAN library - PSOFT company 98';
                1 : Result := 'EAN editor';
	end;
end;

function TAceEanEditor.GetVerbCount: Integer;
begin
	Result:= 2;
end;


procedure Register;
begin
     RegisterComponentEditor(TAceEAN,        TAceEanEditor);
     RegisterComponentEditor(TAceEANMemo,    TAceEanEditor);
     RegisterComponentEditor(TAceDBEAN,      TAceEanEditor);
     RegisterComponentEditor(TAceDBEANMemo,  TAceEanEditor);
     RegisterComponents('EAN components',[TAceEan,TAceEanMemo,TAceDBEan,TAceDBEanMemo]);
end;

end.
